package io.k8s.api.core.v1


/** AzureFile represents an Azure File Service mount on the host and bind mount to the pod. */
final case class AzureFilePersistentVolumeSource(
  readOnly : Option[Boolean] = None,
  secretName : String,
  secretNamespace : Option[String] = None,
  shareName : String
) {
  def withReadOnly(value: Boolean) : AzureFilePersistentVolumeSource = copy(readOnly = Some(value))
  def withSecretName(value: String) : AzureFilePersistentVolumeSource = copy(secretName = value)
  def withSecretNamespace(value: String) : AzureFilePersistentVolumeSource = copy(secretNamespace = Some(value))
  def withShareName(value: String) : AzureFilePersistentVolumeSource = copy(shareName = value)
}

