package io.k8s.api.core.v1


/** AttachedVolume describes a volume attached to a node */
final case class AttachedVolume(
  devicePath : String,
  name : String
) {
  def withDevicePath(value: String) : AttachedVolume = copy(devicePath = value)
  def withName(value: String) : AttachedVolume = copy(name = value)
}

