package io.k8s.api.core.v1


/** Represents a Persistent Disk resource in AWS.

An AWS EBS disk must exist before mounting to a container. The disk must also be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as read/write once. AWS EBS volumes support ownership management and SELinux relabeling. */
final case class AWSElasticBlockStoreVolumeSource(
  fsType : Option[String] = None,
  partition : Option[Int] = None,
  readOnly : Option[Boolean] = None,
  volumeID : String
) {
  def withFsType(value: String) : AWSElasticBlockStoreVolumeSource = copy(fsType = Some(value))
  def withPartition(value: Int) : AWSElasticBlockStoreVolumeSource = copy(partition = Some(value))
  def withReadOnly(value: Boolean) : AWSElasticBlockStoreVolumeSource = copy(readOnly = Some(value))
  def withVolumeID(value: String) : AWSElasticBlockStoreVolumeSource = copy(volumeID = value)
}

