package io.k8s.api.coordination.v1

import dev.hnaderi.k8s._

/** LeaseList is a list of Lease objects. */
final case class LeaseList(
  items : Seq[io.k8s.api.coordination.v1.Lease],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("coordination.k8s.io", "LeaseList", "v1")

  def withItems(value: Seq[io.k8s.api.coordination.v1.Lease]) : LeaseList = copy(items = value)
  def addItems(newValues: io.k8s.api.coordination.v1.Lease*) : LeaseList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : LeaseList = copy(metadata = Some(value))
}

