package io.k8s.api.certificates.v1


/** CertificateSigningRequestSpec contains the certificate request. */
final case class CertificateSigningRequestSpec(
  usages : Option[Seq[String]] = None,
  request : String,
  username : Option[String] = None,
  expirationSeconds : Option[Int] = None,
  groups : Option[Seq[String]] = None,
  uid : Option[String] = None,
  extra : Option[Map[String, Seq[String]]] = None,
  signerName : String
) {
  def withUsages(value: Seq[String]) : CertificateSigningRequestSpec = copy(usages = Some(value))
  def addUsages(newValues: String*) : CertificateSigningRequestSpec = copy(usages = Some(usages.fold(newValues)(_ ++ newValues)))

  def withRequest(value: String) : CertificateSigningRequestSpec = copy(request = value)
  def withUsername(value: String) : CertificateSigningRequestSpec = copy(username = Some(value))
  def withExpirationSeconds(value: Int) : CertificateSigningRequestSpec = copy(expirationSeconds = Some(value))
  def withGroups(value: Seq[String]) : CertificateSigningRequestSpec = copy(groups = Some(value))
  def addGroups(newValues: String*) : CertificateSigningRequestSpec = copy(groups = Some(groups.fold(newValues)(_ ++ newValues)))

  def withUid(value: String) : CertificateSigningRequestSpec = copy(uid = Some(value))
  def withExtra(value: Map[String, Seq[String]]) : CertificateSigningRequestSpec = copy(extra = Some(value))
  def addExtra(newValues: (String, Seq[String])*) : CertificateSigningRequestSpec = copy(extra = Some(extra.fold(newValues.toMap)(_ ++ newValues)))

  def withSignerName(value: String) : CertificateSigningRequestSpec = copy(signerName = value)
}

