package io.k8s.api.batch.v1


/** PodFailurePolicyRule describes how a pod failure is handled when the requirements are met. One of OnExitCodes and onPodConditions, but not both, can be used in each rule. */
final case class PodFailurePolicyRule(
  action : String,
  onExitCodes : Option[io.k8s.api.batch.v1.PodFailurePolicyOnExitCodesRequirement] = None,
  onPodConditions : Seq[io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern]
) {
  def withAction(value: String) : PodFailurePolicyRule = copy(action = value)
  def withOnExitCodes(value: io.k8s.api.batch.v1.PodFailurePolicyOnExitCodesRequirement) : PodFailurePolicyRule = copy(onExitCodes = Some(value))
  def withOnPodConditions(value: Seq[io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern]) : PodFailurePolicyRule = copy(onPodConditions = value)
  def addOnPodConditions(newValues: io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern*) : PodFailurePolicyRule = copy(onPodConditions = onPodConditions ++ newValues)

}

