package io.k8s.api.batch.v1


/** JobTemplateSpec describes the data a Job should have when created from a template */
final case class JobTemplateSpec(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : Option[io.k8s.api.batch.v1.JobSpec] = None
) {
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : JobTemplateSpec = copy(metadata = Some(value))
  def withSpec(value: io.k8s.api.batch.v1.JobSpec) : JobTemplateSpec = copy(spec = Some(value))
}

