package io.k8s.api.batch.v1


/** JobStatus represents the current state of a Job. */
final case class JobStatus(
  conditions : Option[Seq[io.k8s.api.batch.v1.JobCondition]] = None,
  uncountedTerminatedPods : Option[io.k8s.api.batch.v1.UncountedTerminatedPods] = None,
  completedIndexes : Option[String] = None,
  startTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  ready : Option[Int] = None,
  failed : Option[Int] = None,
  succeeded : Option[Int] = None,
  completionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  active : Option[Int] = None
) {
  def withConditions(value: Seq[io.k8s.api.batch.v1.JobCondition]) : JobStatus = copy(conditions = Some(value))
  def addConditions(newValues: io.k8s.api.batch.v1.JobCondition*) : JobStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))

  def withUncountedTerminatedPods(value: io.k8s.api.batch.v1.UncountedTerminatedPods) : JobStatus = copy(uncountedTerminatedPods = Some(value))
  def withCompletedIndexes(value: String) : JobStatus = copy(completedIndexes = Some(value))
  def withStartTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : JobStatus = copy(startTime = Some(value))
  def withReady(value: Int) : JobStatus = copy(ready = Some(value))
  def withFailed(value: Int) : JobStatus = copy(failed = Some(value))
  def withSucceeded(value: Int) : JobStatus = copy(succeeded = Some(value))
  def withCompletionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : JobStatus = copy(completionTime = Some(value))
  def withActive(value: Int) : JobStatus = copy(active = Some(value))
}

