package io.k8s.api.batch.v1


/** JobSpec describes how the job execution will look like. */
final case class JobSpec(
  parallelism : Option[Int] = None,
  completionMode : Option[String] = None,
  podFailurePolicy : Option[io.k8s.api.batch.v1.PodFailurePolicy] = None,
  manualSelector : Option[Boolean] = None,
  suspend : Option[Boolean] = None,
  template : io.k8s.api.core.v1.PodTemplateSpec,
  backoffLimit : Option[Int] = None,
  activeDeadlineSeconds : Option[Int] = None,
  completions : Option[Int] = None,
  ttlSecondsAfterFinished : Option[Int] = None,
  selector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
) {
  def withParallelism(value: Int) : JobSpec = copy(parallelism = Some(value))
  def withCompletionMode(value: String) : JobSpec = copy(completionMode = Some(value))
  def withPodFailurePolicy(value: io.k8s.api.batch.v1.PodFailurePolicy) : JobSpec = copy(podFailurePolicy = Some(value))
  def withManualSelector(value: Boolean) : JobSpec = copy(manualSelector = Some(value))
  def withSuspend(value: Boolean) : JobSpec = copy(suspend = Some(value))
  def withTemplate(value: io.k8s.api.core.v1.PodTemplateSpec) : JobSpec = copy(template = value)
  def withBackoffLimit(value: Int) : JobSpec = copy(backoffLimit = Some(value))
  def withActiveDeadlineSeconds(value: Int) : JobSpec = copy(activeDeadlineSeconds = Some(value))
  def withCompletions(value: Int) : JobSpec = copy(completions = Some(value))
  def withTtlSecondsAfterFinished(value: Int) : JobSpec = copy(ttlSecondsAfterFinished = Some(value))
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : JobSpec = copy(selector = Some(value))
}

