package io.k8s.api.batch.v1


/** CronJobStatus represents the current state of a cron job. */
final case class CronJobStatus(
  active : Option[Seq[io.k8s.api.core.v1.ObjectReference]] = None,
  lastScheduleTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  lastSuccessfulTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
) {
  def withActive(value: Seq[io.k8s.api.core.v1.ObjectReference]) : CronJobStatus = copy(active = Some(value))
  def addActive(newValues: io.k8s.api.core.v1.ObjectReference*) : CronJobStatus = copy(active = Some(active.fold(newValues)(_ ++ newValues)))

  def withLastScheduleTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : CronJobStatus = copy(lastScheduleTime = Some(value))
  def withLastSuccessfulTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : CronJobStatus = copy(lastSuccessfulTime = Some(value))
}

