package io.k8s.api.batch.v1


/** CronJobSpec describes how the job execution will look like and when it will actually run. */
final case class CronJobSpec(
  startingDeadlineSeconds : Option[Int] = None,
  concurrencyPolicy : Option[String] = None,
  failedJobsHistoryLimit : Option[Int] = None,
  successfulJobsHistoryLimit : Option[Int] = None,
  suspend : Option[Boolean] = None,
  schedule : String,
  jobTemplate : io.k8s.api.batch.v1.JobTemplateSpec,
  timeZone : Option[String] = None
) {
  def withStartingDeadlineSeconds(value: Int) : CronJobSpec = copy(startingDeadlineSeconds = Some(value))
  def withConcurrencyPolicy(value: String) : CronJobSpec = copy(concurrencyPolicy = Some(value))
  def withFailedJobsHistoryLimit(value: Int) : CronJobSpec = copy(failedJobsHistoryLimit = Some(value))
  def withSuccessfulJobsHistoryLimit(value: Int) : CronJobSpec = copy(successfulJobsHistoryLimit = Some(value))
  def withSuspend(value: Boolean) : CronJobSpec = copy(suspend = Some(value))
  def withSchedule(value: String) : CronJobSpec = copy(schedule = value)
  def withJobTemplate(value: io.k8s.api.batch.v1.JobTemplateSpec) : CronJobSpec = copy(jobTemplate = value)
  def withTimeZone(value: String) : CronJobSpec = copy(timeZone = Some(value))
}

