package io.k8s.api.batch.v1

import dev.hnaderi.k8s._

/** CronJob represents the configuration of a single cron job. */
final case class CronJob(
  status : Option[io.k8s.api.batch.v1.CronJobStatus] = None,
  spec : Option[io.k8s.api.batch.v1.CronJobSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("batch", "CronJob", "v1")

  def withStatus(value: io.k8s.api.batch.v1.CronJobStatus) : CronJob = copy(status = Some(value))
  def withSpec(value: io.k8s.api.batch.v1.CronJobSpec) : CronJob = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : CronJob = copy(metadata = Some(value))
}

