package io.k8s.api.autoscaling.v2beta2


/** ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object). */
final case class ObjectMetricStatus(
  current : io.k8s.api.autoscaling.v2beta2.MetricValueStatus,
  describedObject : io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference,
  metric : io.k8s.api.autoscaling.v2beta2.MetricIdentifier
) {
  def withCurrent(value: io.k8s.api.autoscaling.v2beta2.MetricValueStatus) : ObjectMetricStatus = copy(current = value)
  def withDescribedObject(value: io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference) : ObjectMetricStatus = copy(describedObject = value)
  def withMetric(value: io.k8s.api.autoscaling.v2beta2.MetricIdentifier) : ObjectMetricStatus = copy(metric = value)
}

