package io.k8s.api.autoscaling.v2beta2


/** ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object). */
final case class ObjectMetricSource(
  describedObject : io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference,
  metric : io.k8s.api.autoscaling.v2beta2.MetricIdentifier,
  target : io.k8s.api.autoscaling.v2beta2.MetricTarget
) {
  def withDescribedObject(value: io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference) : ObjectMetricSource = copy(describedObject = value)
  def withMetric(value: io.k8s.api.autoscaling.v2beta2.MetricIdentifier) : ObjectMetricSource = copy(metric = value)
  def withTarget(value: io.k8s.api.autoscaling.v2beta2.MetricTarget) : ObjectMetricSource = copy(target = value)
}

