package io.k8s.api.autoscaling.v2beta2


/** HorizontalPodAutoscalerStatus describes the current status of a horizontal pod autoscaler. */
final case class HorizontalPodAutoscalerStatus(
  conditions : Option[Seq[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerCondition]] = None,
  desiredReplicas : Int,
  currentMetrics : Option[Seq[io.k8s.api.autoscaling.v2beta2.MetricStatus]] = None,
  lastScaleTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  observedGeneration : Option[Int] = None,
  currentReplicas : Int
) {
  def withConditions(value: Seq[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerCondition]) : HorizontalPodAutoscalerStatus = copy(conditions = Some(value))
  def addConditions(newValues: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerCondition*) : HorizontalPodAutoscalerStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))

  def withDesiredReplicas(value: Int) : HorizontalPodAutoscalerStatus = copy(desiredReplicas = value)
  def withCurrentMetrics(value: Seq[io.k8s.api.autoscaling.v2beta2.MetricStatus]) : HorizontalPodAutoscalerStatus = copy(currentMetrics = Some(value))
  def addCurrentMetrics(newValues: io.k8s.api.autoscaling.v2beta2.MetricStatus*) : HorizontalPodAutoscalerStatus = copy(currentMetrics = Some(currentMetrics.fold(newValues)(_ ++ newValues)))

  def withLastScaleTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : HorizontalPodAutoscalerStatus = copy(lastScaleTime = Some(value))
  def withObservedGeneration(value: Int) : HorizontalPodAutoscalerStatus = copy(observedGeneration = Some(value))
  def withCurrentReplicas(value: Int) : HorizontalPodAutoscalerStatus = copy(currentReplicas = value)
}

