package io.k8s.api.autoscaling.v2


/** ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source. */
final case class ResourceMetricStatus(
  current : io.k8s.api.autoscaling.v2.MetricValueStatus,
  name : String
) {
  def withCurrent(value: io.k8s.api.autoscaling.v2.MetricValueStatus) : ResourceMetricStatus = copy(current = value)
  def withName(value: String) : ResourceMetricStatus = copy(name = value)
}

