package io.k8s.api.autoscaling.v2


/** MetricTarget defines the target value, average value, or average utilization of a specific metric */
final case class MetricTarget(
  averageUtilization : Option[Int] = None,
  averageValue : Option[io.k8s.apimachinery.pkg.api.resource.Quantity] = None,
  `type` : String,
  value : Option[io.k8s.apimachinery.pkg.api.resource.Quantity] = None
) {
  def withAverageUtilization(value: Int) : MetricTarget = copy(averageUtilization = Some(value))
  def withAverageValue(value: io.k8s.apimachinery.pkg.api.resource.Quantity) : MetricTarget = copy(averageValue = Some(value))
  def withType(value: String) : MetricTarget = copy(`type` = value)
  def withValue(value: io.k8s.apimachinery.pkg.api.resource.Quantity) : MetricTarget = copy(value = Some(value))
}

