package io.k8s.api.autoscaling.v2


/** MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once). */
final case class MetricSpec(
  `object` : Option[io.k8s.api.autoscaling.v2.ObjectMetricSource] = None,
  external : Option[io.k8s.api.autoscaling.v2.ExternalMetricSource] = None,
  containerResource : Option[io.k8s.api.autoscaling.v2.ContainerResourceMetricSource] = None,
  resource : Option[io.k8s.api.autoscaling.v2.ResourceMetricSource] = None,
  pods : Option[io.k8s.api.autoscaling.v2.PodsMetricSource] = None,
  `type` : String
) {
  def withObject(value: io.k8s.api.autoscaling.v2.ObjectMetricSource) : MetricSpec = copy(`object` = Some(value))
  def withExternal(value: io.k8s.api.autoscaling.v2.ExternalMetricSource) : MetricSpec = copy(external = Some(value))
  def withContainerResource(value: io.k8s.api.autoscaling.v2.ContainerResourceMetricSource) : MetricSpec = copy(containerResource = Some(value))
  def withResource(value: io.k8s.api.autoscaling.v2.ResourceMetricSource) : MetricSpec = copy(resource = Some(value))
  def withPods(value: io.k8s.api.autoscaling.v2.PodsMetricSource) : MetricSpec = copy(pods = Some(value))
  def withType(value: String) : MetricSpec = copy(`type` = value)
}

