package io.k8s.api.autoscaling.v2


/** MetricIdentifier defines the name and optionally selector for a metric */
final case class MetricIdentifier(
  name : String,
  selector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
) {
  def withName(value: String) : MetricIdentifier = copy(name = value)
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : MetricIdentifier = copy(selector = Some(value))
}

