package io.k8s.api.autoscaling.v2


/** HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point. */
final case class HorizontalPodAutoscalerCondition(
  reason : Option[String] = None,
  status : String,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  `type` : String
) {
  def withReason(value: String) : HorizontalPodAutoscalerCondition = copy(reason = Some(value))
  def withStatus(value: String) : HorizontalPodAutoscalerCondition = copy(status = value)
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : HorizontalPodAutoscalerCondition = copy(lastTransitionTime = Some(value))
  def withMessage(value: String) : HorizontalPodAutoscalerCondition = copy(message = Some(value))
  def withType(value: String) : HorizontalPodAutoscalerCondition = copy(`type` = value)
}

