package io.k8s.api.autoscaling.v2

import dev.hnaderi.k8s._

/** HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified. */
final case class HorizontalPodAutoscaler(
  status : Option[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerStatus] = None,
  spec : Option[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("autoscaling", "HorizontalPodAutoscaler", "v2")

  def withStatus(value: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerStatus) : HorizontalPodAutoscaler = copy(status = Some(value))
  def withSpec(value: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec) : HorizontalPodAutoscaler = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : HorizontalPodAutoscaler = copy(metadata = Some(value))
}

