package io.k8s.api.autoscaling.v2


/** HPAScalingRules configures the scaling behavior for one direction. These Rules are applied after calculating DesiredReplicas from metrics for the HPA. They can limit the scaling velocity by specifying scaling policies. They can prevent flapping by specifying the stabilization window, so that the number of replicas is not set instantly, instead, the safest value from the stabilization window is chosen. */
final case class HPAScalingRules(
  policies : Option[Seq[io.k8s.api.autoscaling.v2.HPAScalingPolicy]] = None,
  selectPolicy : Option[String] = None,
  stabilizationWindowSeconds : Option[Int] = None
) {
  def withPolicies(value: Seq[io.k8s.api.autoscaling.v2.HPAScalingPolicy]) : HPAScalingRules = copy(policies = Some(value))
  def addPolicies(newValues: io.k8s.api.autoscaling.v2.HPAScalingPolicy*) : HPAScalingRules = copy(policies = Some(policies.fold(newValues)(_ ++ newValues)))

  def withSelectPolicy(value: String) : HPAScalingRules = copy(selectPolicy = Some(value))
  def withStabilizationWindowSeconds(value: Int) : HPAScalingRules = copy(stabilizationWindowSeconds = Some(value))
}

