package io.k8s.api.autoscaling.v1

import dev.hnaderi.k8s._

/** Scale represents a scaling request for a resource. */
final case class Scale(
  status : Option[io.k8s.api.autoscaling.v1.ScaleStatus] = None,
  spec : Option[io.k8s.api.autoscaling.v1.ScaleSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("autoscaling", "Scale", "v1")

  def withStatus(value: io.k8s.api.autoscaling.v1.ScaleStatus) : Scale = copy(status = Some(value))
  def withSpec(value: io.k8s.api.autoscaling.v1.ScaleSpec) : Scale = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Scale = copy(metadata = Some(value))
}

