package io.k8s.api.authorization.v1


/** SubjectRulesReviewStatus contains the result of a rules check. This check can be incomplete depending on the set of authorizers the server is configured with and any errors experienced during evaluation. Because authorization rules are additive, if a rule appears in a list it's safe to assume the subject has that permission, even if that list is incomplete. */
final case class SubjectRulesReviewStatus(
  evaluationError : Option[String] = None,
  incomplete : Boolean,
  nonResourceRules : Seq[io.k8s.api.authorization.v1.NonResourceRule],
  resourceRules : Seq[io.k8s.api.authorization.v1.ResourceRule]
) {
  def withEvaluationError(value: String) : SubjectRulesReviewStatus = copy(evaluationError = Some(value))
  def withIncomplete(value: Boolean) : SubjectRulesReviewStatus = copy(incomplete = value)
  def withNonResourceRules(value: Seq[io.k8s.api.authorization.v1.NonResourceRule]) : SubjectRulesReviewStatus = copy(nonResourceRules = value)
  def addNonResourceRules(newValues: io.k8s.api.authorization.v1.NonResourceRule*) : SubjectRulesReviewStatus = copy(nonResourceRules = nonResourceRules ++ newValues)

  def withResourceRules(value: Seq[io.k8s.api.authorization.v1.ResourceRule]) : SubjectRulesReviewStatus = copy(resourceRules = value)
  def addResourceRules(newValues: io.k8s.api.authorization.v1.ResourceRule*) : SubjectRulesReviewStatus = copy(resourceRules = resourceRules ++ newValues)

}

