package io.k8s.api.authorization.v1


/** ResourceRule is the list of actions the subject is allowed to perform on resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete. */
final case class ResourceRule(
  apiGroups : Option[Seq[String]] = None,
  resourceNames : Option[Seq[String]] = None,
  resources : Option[Seq[String]] = None,
  verbs : Seq[String]
) {
  def withApiGroups(value: Seq[String]) : ResourceRule = copy(apiGroups = Some(value))
  def addApiGroups(newValues: String*) : ResourceRule = copy(apiGroups = Some(apiGroups.fold(newValues)(_ ++ newValues)))

  def withResourceNames(value: Seq[String]) : ResourceRule = copy(resourceNames = Some(value))
  def addResourceNames(newValues: String*) : ResourceRule = copy(resourceNames = Some(resourceNames.fold(newValues)(_ ++ newValues)))

  def withResources(value: Seq[String]) : ResourceRule = copy(resources = Some(value))
  def addResources(newValues: String*) : ResourceRule = copy(resources = Some(resources.fold(newValues)(_ ++ newValues)))

  def withVerbs(value: Seq[String]) : ResourceRule = copy(verbs = value)
  def addVerbs(newValues: String*) : ResourceRule = copy(verbs = verbs ++ newValues)

}

