package io.k8s.api.authentication.v1


/** TokenReviewStatus is the result of the token authentication request. */
final case class TokenReviewStatus(
  audiences : Option[Seq[String]] = None,
  authenticated : Option[Boolean] = None,
  error : Option[String] = None,
  user : Option[io.k8s.api.authentication.v1.UserInfo] = None
) {
  def withAudiences(value: Seq[String]) : TokenReviewStatus = copy(audiences = Some(value))
  def addAudiences(newValues: String*) : TokenReviewStatus = copy(audiences = Some(audiences.fold(newValues)(_ ++ newValues)))

  def withAuthenticated(value: Boolean) : TokenReviewStatus = copy(authenticated = Some(value))
  def withError(value: String) : TokenReviewStatus = copy(error = Some(value))
  def withUser(value: io.k8s.api.authentication.v1.UserInfo) : TokenReviewStatus = copy(user = Some(value))
}

