package io.k8s.api.authentication.v1


/** TokenReviewSpec is a description of the token authentication request. */
final case class TokenReviewSpec(
  audiences : Option[Seq[String]] = None,
  token : Option[String] = None
) {
  def withAudiences(value: Seq[String]) : TokenReviewSpec = copy(audiences = Some(value))
  def addAudiences(newValues: String*) : TokenReviewSpec = copy(audiences = Some(audiences.fold(newValues)(_ ++ newValues)))

  def withToken(value: String) : TokenReviewSpec = copy(token = Some(value))
}

