package io.k8s.api.authentication.v1

import dev.hnaderi.k8s._

/** TokenReview attempts to authenticate a token to a known user. Note: TokenReview requests may be cached by the webhook token authenticator plugin in the kube-apiserver. */
final case class TokenReview(
  status : Option[io.k8s.api.authentication.v1.TokenReviewStatus] = None,
  spec : io.k8s.api.authentication.v1.TokenReviewSpec,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("authentication.k8s.io", "TokenReview", "v1")

  def withStatus(value: io.k8s.api.authentication.v1.TokenReviewStatus) : TokenReview = copy(status = Some(value))
  def withSpec(value: io.k8s.api.authentication.v1.TokenReviewSpec) : TokenReview = copy(spec = value)
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : TokenReview = copy(metadata = Some(value))
}

