package io.k8s.api.authentication.v1


/** TokenRequestStatus is the result of a token request. */
final case class TokenRequestStatus(
  expirationTimestamp : io.k8s.apimachinery.pkg.apis.meta.v1.Time,
  token : String
) {
  def withExpirationTimestamp(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : TokenRequestStatus = copy(expirationTimestamp = value)
  def withToken(value: String) : TokenRequestStatus = copy(token = value)
}

