package io.k8s.api.authentication.v1


/** TokenRequestSpec contains client provided parameters of a token request. */
final case class TokenRequestSpec(
  audiences : Seq[String],
  boundObjectRef : Option[io.k8s.api.authentication.v1.BoundObjectReference] = None,
  expirationSeconds : Option[Int] = None
) {
  def withAudiences(value: Seq[String]) : TokenRequestSpec = copy(audiences = value)
  def addAudiences(newValues: String*) : TokenRequestSpec = copy(audiences = audiences ++ newValues)

  def withBoundObjectRef(value: io.k8s.api.authentication.v1.BoundObjectReference) : TokenRequestSpec = copy(boundObjectRef = Some(value))
  def withExpirationSeconds(value: Int) : TokenRequestSpec = copy(expirationSeconds = Some(value))
}

