package io.k8s.api.authentication.v1


/** BoundObjectReference is a reference to an object that a token is bound to. */
final case class BoundObjectReference(
  name : Option[String] = None,
  uid : Option[String] = None
) {
  def withName(value: String) : BoundObjectReference = copy(name = Some(value))
  def withUid(value: String) : BoundObjectReference = copy(uid = Some(value))
}

