package io.k8s.api.apps.v1


/** StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy. */
final case class StatefulSetUpdateStrategy(
  rollingUpdate : Option[io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy] = None,
  `type` : Option[String] = None
) {
  def withRollingUpdate(value: io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy) : StatefulSetUpdateStrategy = copy(rollingUpdate = Some(value))
  def withType(value: String) : StatefulSetUpdateStrategy = copy(`type` = Some(value))
}

