package io.k8s.api.apps.v1


/** StatefulSetStatus represents the current state of a StatefulSet. */
final case class StatefulSetStatus(
  conditions : Option[Seq[io.k8s.api.apps.v1.StatefulSetCondition]] = None,
  collisionCount : Option[Int] = None,
  replicas : Int,
  availableReplicas : Option[Int] = None,
  observedGeneration : Option[Int] = None,
  currentRevision : Option[String] = None,
  currentReplicas : Option[Int] = None,
  updateRevision : Option[String] = None,
  updatedReplicas : Option[Int] = None,
  readyReplicas : Option[Int] = None
) {
  def withConditions(value: Seq[io.k8s.api.apps.v1.StatefulSetCondition]) : StatefulSetStatus = copy(conditions = Some(value))
  def addConditions(newValues: io.k8s.api.apps.v1.StatefulSetCondition*) : StatefulSetStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))

  def withCollisionCount(value: Int) : StatefulSetStatus = copy(collisionCount = Some(value))
  def withReplicas(value: Int) : StatefulSetStatus = copy(replicas = value)
  def withAvailableReplicas(value: Int) : StatefulSetStatus = copy(availableReplicas = Some(value))
  def withObservedGeneration(value: Int) : StatefulSetStatus = copy(observedGeneration = Some(value))
  def withCurrentRevision(value: String) : StatefulSetStatus = copy(currentRevision = Some(value))
  def withCurrentReplicas(value: Int) : StatefulSetStatus = copy(currentReplicas = Some(value))
  def withUpdateRevision(value: String) : StatefulSetStatus = copy(updateRevision = Some(value))
  def withUpdatedReplicas(value: Int) : StatefulSetStatus = copy(updatedReplicas = Some(value))
  def withReadyReplicas(value: Int) : StatefulSetStatus = copy(readyReplicas = Some(value))
}

