package io.k8s.api.apps.v1

import dev.hnaderi.k8s._

/** StatefulSet represents a set of pods with consistent identities. Identities are defined as:
  - Network: A single stable DNS and hostname.
  - Storage: As many VolumeClaims as requested.

The StatefulSet guarantees that a given network identity will always map to the same storage identity. */
final case class StatefulSet(
  status : Option[io.k8s.api.apps.v1.StatefulSetStatus] = None,
  spec : Option[io.k8s.api.apps.v1.StatefulSetSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "StatefulSet", "v1")

  def withStatus(value: io.k8s.api.apps.v1.StatefulSetStatus) : StatefulSet = copy(status = Some(value))
  def withSpec(value: io.k8s.api.apps.v1.StatefulSetSpec) : StatefulSet = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : StatefulSet = copy(metadata = Some(value))
}

