package io.k8s.api.apps.v1


/** Spec to control the desired behavior of daemon set rolling update. */
final case class RollingUpdateDaemonSet(
  maxSurge : Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString] = None,
  maxUnavailable : Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString] = None
) {
  def withMaxSurge(value: io.k8s.apimachinery.pkg.util.intstr.IntOrString) : RollingUpdateDaemonSet = copy(maxSurge = Some(value))
  def withMaxUnavailable(value: io.k8s.apimachinery.pkg.util.intstr.IntOrString) : RollingUpdateDaemonSet = copy(maxUnavailable = Some(value))
}

