package io.k8s.api.apps.v1


/** ReplicaSetStatus represents the current status of a ReplicaSet. */
final case class ReplicaSetStatus(
  conditions : Option[Seq[io.k8s.api.apps.v1.ReplicaSetCondition]] = None,
  replicas : Int,
  availableReplicas : Option[Int] = None,
  observedGeneration : Option[Int] = None,
  readyReplicas : Option[Int] = None,
  fullyLabeledReplicas : Option[Int] = None
) {
  def withConditions(value: Seq[io.k8s.api.apps.v1.ReplicaSetCondition]) : ReplicaSetStatus = copy(conditions = Some(value))
  def addConditions(newValues: io.k8s.api.apps.v1.ReplicaSetCondition*) : ReplicaSetStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))

  def withReplicas(value: Int) : ReplicaSetStatus = copy(replicas = value)
  def withAvailableReplicas(value: Int) : ReplicaSetStatus = copy(availableReplicas = Some(value))
  def withObservedGeneration(value: Int) : ReplicaSetStatus = copy(observedGeneration = Some(value))
  def withReadyReplicas(value: Int) : ReplicaSetStatus = copy(readyReplicas = Some(value))
  def withFullyLabeledReplicas(value: Int) : ReplicaSetStatus = copy(fullyLabeledReplicas = Some(value))
}

