package io.k8s.api.apps.v1


/** ReplicaSetSpec is the specification of a ReplicaSet. */
final case class ReplicaSetSpec(
  minReadySeconds : Option[Int] = None,
  replicas : Option[Int] = None,
  selector : io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector,
  template : Option[io.k8s.api.core.v1.PodTemplateSpec] = None
) {
  def withMinReadySeconds(value: Int) : ReplicaSetSpec = copy(minReadySeconds = Some(value))
  def withReplicas(value: Int) : ReplicaSetSpec = copy(replicas = Some(value))
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : ReplicaSetSpec = copy(selector = value)
  def withTemplate(value: io.k8s.api.core.v1.PodTemplateSpec) : ReplicaSetSpec = copy(template = Some(value))
}

