package io.k8s.api.apps.v1

import dev.hnaderi.k8s._

/** ReplicaSetList is a collection of ReplicaSets. */
final case class ReplicaSetList(
  items : Seq[io.k8s.api.apps.v1.ReplicaSet],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "ReplicaSetList", "v1")

  def withItems(value: Seq[io.k8s.api.apps.v1.ReplicaSet]) : ReplicaSetList = copy(items = value)
  def addItems(newValues: io.k8s.api.apps.v1.ReplicaSet*) : ReplicaSetList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ReplicaSetList = copy(metadata = Some(value))
}

