package io.k8s.api.apps.v1


/** ReplicaSetCondition describes the state of a replica set at a certain point. */
final case class ReplicaSetCondition(
  reason : Option[String] = None,
  status : String,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  `type` : String
) {
  def withReason(value: String) : ReplicaSetCondition = copy(reason = Some(value))
  def withStatus(value: String) : ReplicaSetCondition = copy(status = value)
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ReplicaSetCondition = copy(lastTransitionTime = Some(value))
  def withMessage(value: String) : ReplicaSetCondition = copy(message = Some(value))
  def withType(value: String) : ReplicaSetCondition = copy(`type` = value)
}

