package io.k8s.api.apps.v1


/** DeploymentStatus is the most recently observed status of the Deployment. */
final case class DeploymentStatus(
  conditions : Option[Seq[io.k8s.api.apps.v1.DeploymentCondition]] = None,
  collisionCount : Option[Int] = None,
  replicas : Option[Int] = None,
  availableReplicas : Option[Int] = None,
  unavailableReplicas : Option[Int] = None,
  observedGeneration : Option[Int] = None,
  updatedReplicas : Option[Int] = None,
  readyReplicas : Option[Int] = None
) {
  def withConditions(value: Seq[io.k8s.api.apps.v1.DeploymentCondition]) : DeploymentStatus = copy(conditions = Some(value))
  def addConditions(newValues: io.k8s.api.apps.v1.DeploymentCondition*) : DeploymentStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))

  def withCollisionCount(value: Int) : DeploymentStatus = copy(collisionCount = Some(value))
  def withReplicas(value: Int) : DeploymentStatus = copy(replicas = Some(value))
  def withAvailableReplicas(value: Int) : DeploymentStatus = copy(availableReplicas = Some(value))
  def withUnavailableReplicas(value: Int) : DeploymentStatus = copy(unavailableReplicas = Some(value))
  def withObservedGeneration(value: Int) : DeploymentStatus = copy(observedGeneration = Some(value))
  def withUpdatedReplicas(value: Int) : DeploymentStatus = copy(updatedReplicas = Some(value))
  def withReadyReplicas(value: Int) : DeploymentStatus = copy(readyReplicas = Some(value))
}

