package io.k8s.api.apps.v1

import dev.hnaderi.k8s._

/** Deployment enables declarative updates for Pods and ReplicaSets. */
final case class Deployment(
  status : Option[io.k8s.api.apps.v1.DeploymentStatus] = None,
  spec : Option[io.k8s.api.apps.v1.DeploymentSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "Deployment", "v1")

  def withStatus(value: io.k8s.api.apps.v1.DeploymentStatus) : Deployment = copy(status = Some(value))
  def withSpec(value: io.k8s.api.apps.v1.DeploymentSpec) : Deployment = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Deployment = copy(metadata = Some(value))
}

