package io.k8s.api.apps.v1

import dev.hnaderi.k8s._

/** DaemonSetList is a collection of daemon sets. */
final case class DaemonSetList(
  items : Seq[io.k8s.api.apps.v1.DaemonSet],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "DaemonSetList", "v1")

  def withItems(value: Seq[io.k8s.api.apps.v1.DaemonSet]) : DaemonSetList = copy(items = value)
  def addItems(newValues: io.k8s.api.apps.v1.DaemonSet*) : DaemonSetList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : DaemonSetList = copy(metadata = Some(value))
}

