package io.k8s.api.apps.v1

import dev.hnaderi.k8s._

/** DaemonSet represents the configuration of a daemon set. */
final case class DaemonSet(
  status : Option[io.k8s.api.apps.v1.DaemonSetStatus] = None,
  spec : Option[io.k8s.api.apps.v1.DaemonSetSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "DaemonSet", "v1")

  def withStatus(value: io.k8s.api.apps.v1.DaemonSetStatus) : DaemonSet = copy(status = Some(value))
  def withSpec(value: io.k8s.api.apps.v1.DaemonSetSpec) : DaemonSet = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : DaemonSet = copy(metadata = Some(value))
}

