package io.k8s.api.apiserverinternal.v1alpha1


/** Describes the state of the storageVersion at a certain point. */
final case class StorageVersionCondition(
  reason : String,
  status : String,
  observedGeneration : Option[Int] = None,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  `type` : String
) {
  def withReason(value: String) : StorageVersionCondition = copy(reason = value)
  def withStatus(value: String) : StorageVersionCondition = copy(status = value)
  def withObservedGeneration(value: Int) : StorageVersionCondition = copy(observedGeneration = Some(value))
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : StorageVersionCondition = copy(lastTransitionTime = Some(value))
  def withMessage(value: String) : StorageVersionCondition = copy(message = Some(value))
  def withType(value: String) : StorageVersionCondition = copy(`type` = value)
}

