package io.k8s.api.apiserverinternal.v1alpha1

import dev.hnaderi.k8s._

/** Storage version of a specific resource. */
final case class StorageVersion(
  status : io.k8s.api.apiserverinternal.v1alpha1.StorageVersionStatus,
  spec : io.k8s.api.apiserverinternal.v1alpha1.StorageVersionSpec,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("internal.apiserver.k8s.io", "StorageVersion", "v1alpha1")

  def withStatus(value: io.k8s.api.apiserverinternal.v1alpha1.StorageVersionStatus) : StorageVersion = copy(status = value)
  def withSpec(value: io.k8s.api.apiserverinternal.v1alpha1.StorageVersionSpec) : StorageVersion = copy(spec = value)
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : StorageVersion = copy(metadata = Some(value))
}

