package io.k8s.api.apiserverinternal.v1alpha1


/** An API server instance reports the version it can decode and the version it encodes objects to when persisting objects in the backend. */
final case class ServerStorageVersion(
  apiServerID : Option[String] = None,
  decodableVersions : Option[Seq[String]] = None,
  encodingVersion : Option[String] = None
) {
  def withApiServerID(value: String) : ServerStorageVersion = copy(apiServerID = Some(value))
  def withDecodableVersions(value: Seq[String]) : ServerStorageVersion = copy(decodableVersions = Some(value))
  def addDecodableVersions(newValues: String*) : ServerStorageVersion = copy(decodableVersions = Some(decodableVersions.fold(newValues)(_ ++ newValues)))

  def withEncodingVersion(value: String) : ServerStorageVersion = copy(encodingVersion = Some(value))
}

