package io.k8s.api.admissionregistration.v1


/** ValidatingWebhook describes an admission webhook and the resources and operations it applies to. */
final case class ValidatingWebhook(
  timeoutSeconds : Option[Int] = None,
  name : String,
  matchPolicy : Option[String] = None,
  namespaceSelector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None,
  sideEffects : String,
  clientConfig : io.k8s.api.admissionregistration.v1.WebhookClientConfig,
  failurePolicy : Option[String] = None,
  rules : Option[Seq[io.k8s.api.admissionregistration.v1.RuleWithOperations]] = None,
  admissionReviewVersions : Seq[String],
  objectSelector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
) {
  def withTimeoutSeconds(value: Int) : ValidatingWebhook = copy(timeoutSeconds = Some(value))
  def withName(value: String) : ValidatingWebhook = copy(name = value)
  def withMatchPolicy(value: String) : ValidatingWebhook = copy(matchPolicy = Some(value))
  def withNamespaceSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : ValidatingWebhook = copy(namespaceSelector = Some(value))
  def withSideEffects(value: String) : ValidatingWebhook = copy(sideEffects = value)
  def withClientConfig(value: io.k8s.api.admissionregistration.v1.WebhookClientConfig) : ValidatingWebhook = copy(clientConfig = value)
  def withFailurePolicy(value: String) : ValidatingWebhook = copy(failurePolicy = Some(value))
  def withRules(value: Seq[io.k8s.api.admissionregistration.v1.RuleWithOperations]) : ValidatingWebhook = copy(rules = Some(value))
  def addRules(newValues: io.k8s.api.admissionregistration.v1.RuleWithOperations*) : ValidatingWebhook = copy(rules = Some(rules.fold(newValues)(_ ++ newValues)))

  def withAdmissionReviewVersions(value: Seq[String]) : ValidatingWebhook = copy(admissionReviewVersions = value)
  def addAdmissionReviewVersions(newValues: String*) : ValidatingWebhook = copy(admissionReviewVersions = admissionReviewVersions ++ newValues)

  def withObjectSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : ValidatingWebhook = copy(objectSelector = Some(value))
}

