package io.k8s.api.admissionregistration.v1


/** ServiceReference holds a reference to Service.legacy.k8s.io */
final case class ServiceReference(
  name : String,
  namespace : String,
  path : Option[String] = None,
  port : Option[Int] = None
) {
  def withName(value: String) : ServiceReference = copy(name = value)
  def withNamespace(value: String) : ServiceReference = copy(namespace = value)
  def withPath(value: String) : ServiceReference = copy(path = Some(value))
  def withPort(value: Int) : ServiceReference = copy(port = Some(value))
}

