package io.k8s.api.admissionregistration.v1


/** RuleWithOperations is a tuple of Operations and Resources. It is recommended to make sure that all the tuple expansions are valid. */
final case class RuleWithOperations(
  operations : Option[Seq[String]] = None,
  apiVersions : Option[Seq[String]] = None,
  scope : Option[String] = None,
  apiGroups : Option[Seq[String]] = None,
  resources : Option[Seq[String]] = None
) {
  def withOperations(value: Seq[String]) : RuleWithOperations = copy(operations = Some(value))
  def addOperations(newValues: String*) : RuleWithOperations = copy(operations = Some(operations.fold(newValues)(_ ++ newValues)))

  def withApiVersions(value: Seq[String]) : RuleWithOperations = copy(apiVersions = Some(value))
  def addApiVersions(newValues: String*) : RuleWithOperations = copy(apiVersions = Some(apiVersions.fold(newValues)(_ ++ newValues)))

  def withScope(value: String) : RuleWithOperations = copy(scope = Some(value))
  def withApiGroups(value: Seq[String]) : RuleWithOperations = copy(apiGroups = Some(value))
  def addApiGroups(newValues: String*) : RuleWithOperations = copy(apiGroups = Some(apiGroups.fold(newValues)(_ ++ newValues)))

  def withResources(value: Seq[String]) : RuleWithOperations = copy(resources = Some(value))
  def addResources(newValues: String*) : RuleWithOperations = copy(resources = Some(resources.fold(newValues)(_ ++ newValues)))

}

