package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s._

/** MutatingWebhookConfigurationList is a list of MutatingWebhookConfiguration. */
final case class MutatingWebhookConfigurationList(
  items : Seq[io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("admissionregistration.k8s.io", "MutatingWebhookConfigurationList", "v1")

  def withItems(value: Seq[io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration]) : MutatingWebhookConfigurationList = copy(items = value)
  def addItems(newValues: io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration*) : MutatingWebhookConfigurationList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : MutatingWebhookConfigurationList = copy(metadata = Some(value))
}

